<?php
 /**
  * Template Name: About Us 2024
  * @link https://codex.wordpress.org/Template_Hierarchy
  * @package Microtest
  */

get_header();

$id = get_the_ID();

$args = array(
    'post_type' => 'clients'
);

$query = new WP_Query($args);
$sliders = array();
$i=0;
while( $query->have_posts() ) {
    $query->the_post();
    array_push($sliders, get_the_post_thumbnail_url( get_the_ID(), 'post-thumbnail' ) );
    $i++;
}

wp_reset_postdata();

?>


<main id="content" class="main-about-us aboutUs2024">
    <div class="about-us-header">
        <div class="new-thumbnail-hero" style="">
          <div class="container">
            <div class="row">
              <div class="colonna col-12 col-md-6">
                
                <h1 style=""><?php echo get_field('header_text'); ?></h1>
              </div>
              <div class="colonna col-12 col-md-6">
              <?php if(get_field('immagine_cubo_per_jumbotron')){; ?>
                <img src="<?php echo get_field('immagine_cubo_per_jumbotron')['url']; ?>" alt="<?php echo get_field('immagine_cubo_per_jumbotron')['alt']; ?>" class="img-jumbotron">
              <?php } ?>
              </div>
            </div>
          </div>
        </div>
        <!-- <div class="contieni-video-jumbotron">
          <video id="video-jumbotron" loop="loop"  width="100%" height="100%"  autoplay muted playsinline loop poster="img.png" class="video-jumbotron">
            <source src="<?php echo get_field('url_video_about_us'); ?>" type="video/mp4">
          </video>
        </div> -->
    </div>
    
    <div class="sezione section-about">
      <div class="container">
          <div class="row microtest-about">
            <div class="col-12 col-lg-6" style="padding: 0; display: flex; align-items: center; justify-content:center">
            <div class="contieni-imgs-chip">
              <?php if(get_field('immagine_chip_mg')){; ?>
                <img src="<?php echo get_field('immagine_chip_mg')['url']; ?>" alt="<?php echo get_field('immagine_chip_mg')['alt']; ?>" class="img-chip">
              <?php } ?>
              <?php if(get_field('immagine_testo_chip_mg')){; ?>
                <img src="<?php echo get_field('immagine_testo_chip_mg')['url']; ?>" alt="<?php echo get_field('immagine_testo_chip_mg')['alt']; ?>" class="img-testo">
              <?php } ?>
            </div>
            </div>
            <div class="col-12 col-lg-6 conTesto testo-standard">
              <?php echo get_field('testo_mg'); ?>
            </div>
          </div>
        </div>
    </div>

    <section class="turnkey-solutions">
      <h2><?php echo get_field('titolo_turnkey_solutions') ?></h2>
      <div class="contieni-boxes">
        <?php 
        $fasciaTurnKey = get_field('fascia_turnkey_solutions_boxes');
        $indiceBox = 0;
        foreach ($fasciaTurnKey as $singleBox) { 
          $indiceBox++; 
          ?>
          <div class="singleBox single-box-<?php echo $indiceBox ?>">
            <img src="<?php echo $singleBox['singola_box']['icona_box']['url'] ?>" alt="<?php echo $singleBox['singola_box']['icona_box']['alt'] ?>">
            <div class="testo">
              <?php echo $singleBox['singola_box']['testo_box'] ?>
            </div>
          </div>
        <?php  } ?>
      </div>
      <script>
        /* rendere scrollable la sezione */
        const elemento_scrollabileX = document.querySelector('.contieni-boxes');
        let isDown = false;
        let startX;
        let scrollLeft;

        elemento_scrollabileX.addEventListener('mousedown', (e) => {
            isDown = true;
            elemento_scrollabileX.classList.add('active');
            startX = e.pageX - elemento_scrollabileX.offsetLeft;
            scrollLeft = elemento_scrollabileX.scrollLeft;
        });
        elemento_scrollabileX.addEventListener('mouseleave', () => {
            isDown = false;
            elemento_scrollabileX.classList.remove('active');
        });
        elemento_scrollabileX.addEventListener('mouseup', () => {
            isDown = false;
            elemento_scrollabileX.classList.remove('active');
        });
        elemento_scrollabileX.addEventListener('mousemove', (e) => {
            if(!isDown) return;
            e.preventDefault();
            const x = e.pageX - elemento_scrollabileX.offsetLeft;
            const walk = (x - startX) * 1.5; //scroll speed
            elemento_scrollabileX.scrollLeft = scrollLeft - walk;
            /* console.log(walk); */
        });
      </script>
    </section>

    <section class="introducing-maps">
      <div class="container testi-introducing">
        <?php echo get_field('introducing_mg_1') ?>
        <div class="immagine-link-sovrapposti">
          <?php $immagineLinks = get_field('introducing_mg_links') ?>
          <?php  if($immagineLinks['immagine_mg']) { ?>
            <img src="<?php echo $immagineLinks['immagine_mg']['url'] ?>" alt="<?php echo $immagineLinks['immagine_mg']['alt'] ?>">
            <?php  if($immagineLinks['link_top_left']) { ?>
              <a href="<?php echo $immagineLinks['link_top_left']['url']?>" class="link-top-left" target="blank"><?php echo $immagineLinks['link_top_left']['url']?></a>
            <?php  } ?>
            <?php  if($immagineLinks['link_top_right']) { ?>
              <a href="<?php echo $immagineLinks['link_top_right']['url']?>" class="link-top-right" target="blank"><?php echo $immagineLinks['link_top_right']['url']?></a>
            <?php  } ?>
            <?php  if($immagineLinks['link_center_left']) { ?>
              <a href="<?php echo $immagineLinks['link_center_left']['url']?>" class="link-center-left" target="blank"><?php echo $immagineLinks['link_center_left']['url']?></a>
            <?php  } ?>
            <?php  if($immagineLinks['link_center_right']) { ?>
              <a href="<?php echo $immagineLinks['link_center_right']['url']?>" class="link-center-right" target="blank"><?php echo $immagineLinks['link_center_right']['url']?></a>
            <?php  } ?>
            <?php  if($immagineLinks['link_bottom_left']) { ?>
              <a href="<?php echo $immagineLinks['link_bottom_left']['url']?>" class="link-bottom-left" target="blank"><?php echo $immagineLinks['link_bottom_left']['url']?></a>
            <?php  } ?>
            <?php  if($immagineLinks['link_bottom_right']) { ?>
              <a href="<?php echo $immagineLinks['link_bottom_right']['url']?>" class="link-bottom-right" target="blank"><?php echo $immagineLinks['link_bottom_right']['url']?></a>
            <?php  } ?>

          <?php  } ?>
          
        </div>
        <?php echo get_field('introducing_mg_2') ?>
      </div>
      <div class="contieni-mappe">
        <div class="container">
          <?php $testiMappe = get_field('testi_mappe'); ?>
          <div class="mappe-mobile d-lg-none">
            <div class="mappa mappa-europa">
              <?php if(get_field('mappa_mobile_1')){ ?>
                <img src="<?php echo get_field('mappa_mobile_1')['url'] ?>" alt="<?php echo get_field('mappa_mobile_1')['alt'] ?>" class="mappa-mobile-1">
              <?php } ?>
              <div class="testi-mappa">
                <div class="single-box olanda">
                  <div class="pin">+</div>
                  <div class="testi-box">
                    <div class="titoletto">
                      <?php echo $testiMappe['olanda']['titoletto'] ?>
                      <?php if($testiMappe['olanda']['immagine_bandiera']) { ?>
                      <img src="<?php echo $testiMappe['olanda']['immagine_bandiera']['url'] ?>" alt=" <?php echo $testiMappe['olanda']['titoletto'] ?> flag">
                      <?php } ?>
                    </div>
                    <div class="titolo">
                      <?php if($testiMappe['olanda']['link_collegato']) { ?>
                        <a href="<?php echo $testiMappe['olanda']['link_collegato']['url'] ?>" target="_blank"><?php echo $testiMappe['olanda']['titolo'] ?></a>
                      <?php } else { ?>
                        <?php echo $testiMappe['olanda']['titolo'] ?>
                      <?php }  ?>
                    </div>
                    <div class="testo">
                      <?php echo $testiMappe['olanda']['testo'] ?>
                    </div>
                  </div>
                </div>
                <div class="single-box germania">
                  <div class="pin">+</div>
                  <div class="testi-box">
                    <div class="titoletto">
                      <?php echo $testiMappe['germania']['titoletto'] ?>
                      <?php if($testiMappe['germania']['immagine_bandiera']) { ?>
                      <img src="<?php echo $testiMappe['germania']['immagine_bandiera']['url'] ?>" alt=" <?php echo $testiMappe['germania']['titoletto'] ?> flag">
                      <?php } ?>
                    </div>
                    <div class="titolo">
                      <?php if($testiMappe['germania']['link_collegato']) { ?>
                        <a href="<?php echo $testiMappe['germania']['link_collegato']['url'] ?>" target="_blank"><?php echo $testiMappe['germania']['titolo'] ?></a>
                      <?php } else { ?>
                        <?php echo $testiMappe['germania']['titolo'] ?>
                      <?php }  ?>
                    </div>
                    <div class="testo">
                      <?php echo $testiMappe['germania']['testo'] ?>
                    </div>
                  </div>
                </div>
                <div class="single-box genova">
                  <div class="pin">+</div>
                  <div class="testi-box">
                    <div class="titoletto">
                      <?php echo $testiMappe['genova']['titoletto'] ?>
                      <?php if($testiMappe['genova']['immagine_bandiera']) { ?>
                      <img src="<?php echo $testiMappe['genova']['immagine_bandiera']['url'] ?>" alt=" <?php echo $testiMappe['genova']['titoletto'] ?> flag">
                      <?php } ?>
                    </div>
                    <div class="titolo">
                      <?php if($testiMappe['genova']['link_collegato']) { ?>
                        <a href="<?php echo $testiMappe['genova']['link_collegato']['url'] ?>" target="_blank"><?php echo $testiMappe['genova']['titolo'] ?></a>
                      <?php } else { ?>
                        <?php echo $testiMappe['genova']['titolo'] ?>
                      <?php }  ?>
                    </div>
                    <div class="testo">
                      <?php echo $testiMappe['genova']['testo'] ?>
                    </div>
                  </div>
                </div>
                <div class="single-box microtest_sede">
                  <div class="pin">+</div>
                  <div class="testi-box">
                    <div class="titoletto">
                      <?php echo $testiMappe['microtest_sede']['titoletto'] ?>
                      <?php if($testiMappe['microtest_sede']['immagine_bandiera']) { ?>
                      <img src="<?php echo $testiMappe['microtest_sede']['immagine_bandiera']['url'] ?>" alt=" <?php echo $testiMappe['microtest_sede']['titoletto'] ?> flag">
                      <?php } ?>
                    </div>
                    <div class="titolo">
                      <?php if($testiMappe['microtest_sede']['link_collegato']) { ?>
                        <a href="<?php echo $testiMappe['microtest_sede']['link_collegato']['url'] ?>" target="_blank"><?php echo $testiMappe['microtest_sede']['titolo'] ?></a>
                      <?php } else { ?>
                        <?php echo $testiMappe['microtest_sede']['titolo'] ?>
                      <?php }  ?>
                    </div>
                    <div class="testo">
                      <?php echo $testiMappe['microtest_sede']['testo'] ?>
                    </div>
                  </div>
                </div>
                <div class="single-box england">
                  <div class="pin">+</div>
                  <div class="testi-box">
                    <div class="titoletto">
                      <?php echo $testiMappe['england']['titoletto'] ?>
                      <?php if($testiMappe['england']['immagine_bandiera']) { ?>
                      <img src="<?php echo $testiMappe['england']['immagine_bandiera']['url'] ?>" alt=" <?php echo $testiMappe['england']['titoletto'] ?> flag">
                      <?php } ?>
                    </div>
                    <div class="titolo">
                      <?php if($testiMappe['england']['link_collegato']) { ?>
                        <a href="<?php echo $testiMappe['england']['link_collegato']['url'] ?>" target="_blank"><?php echo $testiMappe['england']['titolo'] ?></a>
                      <?php } else { ?>
                        <?php echo $testiMappe['england']['titolo'] ?>
                      <?php }  ?>
                    </div>
                    <div class="testo">
                      <?php echo $testiMappe['england']['testo'] ?>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="mappa mappa-asia">
              <?php if(get_field('mappa_mobile_2')){ ?>
                <img src="<?php echo get_field('mappa_mobile_2')['url'] ?>" alt="<?php echo get_field('mappa_mobile_2')['url'] ?>">
              <?php } ?>
              <div class="testi-mappa">
                <div class="single-box pacific">
                  <div class="pin">+</div>
                  <div class="testi-box">
                    <div class="titoletto">
                      <?php echo $testiMappe['pacific']['titoletto'] ?>
                      <?php if($testiMappe['pacific']['immagine_bandiera']) { ?>
                      <img src="<?php echo $testiMappe['pacific']['immagine_bandiera']['url'] ?>" alt=" <?php echo $testiMappe['pacific']['titoletto'] ?> flag">
                      <?php } ?>
                    </div>
                    <div class="titolo">
                      <?php if($testiMappe['pacific']['link_collegato']) { ?>
                        <a href="<?php echo $testiMappe['pacific']['link_collegato']['url'] ?>" target="_blank"><?php echo $testiMappe['pacific']['titolo'] ?></a>
                      <?php } else { ?>
                        <?php echo $testiMappe['pacific']['titolo'] ?>
                      <?php }  ?>
                    </div>
                    <div class="testo">
                      <?php echo $testiMappe['pacific']['testo'] ?>
                    </div>
                  </div>
                </div>
                <div class="single-box singapore">
                  <div class="pin">+</div>
                  <div class="testi-box">
                    <div class="titoletto">
                      <?php echo $testiMappe['singapore']['titoletto'] ?>
                      <?php if($testiMappe['singapore']['immagine_bandiera']) { ?>
                      <img src="<?php echo $testiMappe['singapore']['immagine_bandiera']['url'] ?>" alt=" <?php echo $testiMappe['singapore']['titoletto'] ?> flag">
                      <?php } ?>
                    </div>
                    <div class="titolo">
                      <?php if($testiMappe['singapore']['link_collegato']) { ?>
                        <a href="<?php echo $testiMappe['singapore']['link_collegato']['url'] ?>" target="_blank"><?php echo $testiMappe['singapore']['titolo'] ?></a>
                      <?php } else { ?>
                        <?php echo $testiMappe['singapore']['titolo'] ?>
                      <?php }  ?>
                    </div>
                    <div class="testo">
                      <?php echo $testiMappe['singapore']['testo'] ?>
                    </div>
                  </div>
                </div>
                
                <div class="single-box iptest_malesia">
                  <div class="pin">+</div>
                  <div class="testi-box">
                    <div class="titoletto">
                      <?php echo $testiMappe['iptest_malesia']['titoletto'] ?>
                      <?php if($testiMappe['iptest_malesia']['immagine_bandiera']) { ?>
                      <img src="<?php echo $testiMappe['iptest_malesia']['immagine_bandiera']['url'] ?>" alt=" <?php echo $testiMappe['iptest_malesia']['titoletto'] ?> flag">
                      <?php } ?>
                    </div>
                    <div class="titolo">
                      <?php if($testiMappe['iptest_malesia']['link_collegato']) { ?>
                        <a href="<?php echo $testiMappe['iptest_malesia']['link_collegato']['url'] ?>" target="_blank"><?php echo $testiMappe['iptest_malesia']['titolo'] ?></a>
                      <?php } else { ?>
                        <?php echo $testiMappe['iptest_malesia']['titolo'] ?>
                      <?php }  ?>
                    </div>
                    <div class="testo">
                      <?php echo $testiMappe['iptest_malesia']['testo'] ?>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="mappe-desktop d-none d-lg-flex">
            <div class="container">
              <?php if(get_field('mappa_desktop')){ ?>
                <img src="<?php echo get_field('mappa_desktop')['url'] ?>" alt="<?php echo get_field('mappa_desktop')['alt'] ?>">
              <?php } ?>
              <div class="testi-mappa">
                <div class="single-box olanda">
                  <div class="testi-box">
                    <div class="titoletto">
                      <?php echo $testiMappe['olanda']['titoletto'] ?>
                      <?php if($testiMappe['olanda']['immagine_bandiera']) { ?>
                      <img src="<?php echo $testiMappe['olanda']['immagine_bandiera']['url'] ?>" alt=" <?php echo $testiMappe['olanda']['titoletto'] ?> flag">
                        <?php } ?>
                    </div>
                    <div class="titolo"> 
                      <?php if($testiMappe['olanda']['link_collegato']) { ?>
                        <a href="<?php echo $testiMappe['olanda']['link_collegato']['url'] ?>" target="_blank"><?php echo $testiMappe['olanda']['titolo'] ?></a>
                      <?php } else { ?>
                        <?php echo $testiMappe['olanda']['titolo'] ?>
                      <?php }  ?>
                    </div>
                    <div class="testo">
                      <?php echo $testiMappe['olanda']['testo'] ?>
                    </div>
                  </div>
                </div>
                <div class="single-box germania">
                  <div class="testi-box">
                    <div class="titoletto">
                      <?php if($testiMappe['germania']['immagine_bandiera']) { ?>
                      <img src="<?php echo $testiMappe['germania']['immagine_bandiera']['url'] ?>" alt=" <?php echo $testiMappe['germania']['titoletto'] ?> flag">
                        <?php } ?>
                      <?php echo $testiMappe['germania']['titoletto'] ?>
                    </div>
                    <div class="titolo">
                      <?php if($testiMappe['germania']['link_collegato']) { ?>
                        <a href="<?php echo $testiMappe['germania']['link_collegato']['url'] ?>" target="_blank"><?php echo $testiMappe['germania']['titolo'] ?></a>
                      <?php } else { ?>
                        <?php echo $testiMappe['germania']['titolo'] ?>
                      <?php }  ?>
                    </div>
                    <div class="testo">
                      <?php echo $testiMappe['germania']['testo'] ?>
                    </div>
                  </div>
                </div>
                <div class="single-box genova">
                  <div class="testi-box">
                    <div class="titoletto">
                      <?php echo $testiMappe['genova']['titoletto'] ?>
                      <?php if($testiMappe['genova']['immagine_bandiera']) { ?>
                      <img src="<?php echo $testiMappe['genova']['immagine_bandiera']['url'] ?>" alt="<?php echo $testiMappe['genova']['titoletto'] ?> flag">
                      <?php } ?>
                    </div>
                    <div class="titolo">
                       <?php if($testiMappe['genova']['link_collegato']) { ?>
                        <a href="<?php echo $testiMappe['genova']['link_collegato']['url'] ?>" target="_blank"><?php echo $testiMappe['genova']['titolo'] ?></a>
                      <?php } else { ?>
                        <?php echo $testiMappe['genova']['titolo'] ?>
                      <?php }  ?>
                    </div>
                    <div class="testo">
                      <?php echo $testiMappe['genova']['testo'] ?>
                    </div>
                  </div>
                </div>
                <div class="single-box microtest_sede">
                  <div class="testi-box">
                    <div class="testo">
                      <?php echo $testiMappe['microtest_sede']['testo'] ?>
                    </div>
                    <div class="titolo">
                      <?php if($testiMappe['microtest_sede']['link_collegato']) { ?>
                        <a href="<?php echo $testiMappe['microtest_sede']['link_collegato']['url'] ?>" target="_blank"><?php echo $testiMappe['microtest_sede']['titolo'] ?></a>
                      <?php } else { ?>
                        <?php echo $testiMappe['microtest_sede']['titolo'] ?>
                      <?php }  ?>
                    </div>
                    <div class="titoletto">
                      <?php if($testiMappe['microtest_sede']['immagine_bandiera']) { ?>
                      <img src="<?php echo $testiMappe['microtest_sede']['immagine_bandiera']['url'] ?>" alt="<?php echo $testiMappe['microtest_sede']['titoletto'] ?> flag">
                      <?php } ?>
                      <?php echo $testiMappe['microtest_sede']['titoletto'] ?>
                    </div>
                  </div>
                </div>
                <div class="single-box pacific">
                  <div class="testi-box">
                    <div class="titoletto">
                      <?php echo $testiMappe['pacific']['titoletto'] ?>
                      <?php if($testiMappe['pacific']['immagine_bandiera']) { ?>
                      <img src="<?php echo $testiMappe['pacific']['immagine_bandiera']['url'] ?>" alt=" <?php echo $testiMappe['pacific']['titoletto'] ?> flag">
                      <?php } ?>
                    </div>
                    <div class="titolo">
                      <?php if($testiMappe['pacific']['link_collegato']) { ?>
                        <a href="<?php echo $testiMappe['pacific']['link_collegato']['url'] ?>" target="_blank"><?php echo $testiMappe['pacific']['titolo'] ?></a>
                      <?php } else { ?>
                        <?php echo $testiMappe['pacific']['titolo'] ?>
                      <?php }  ?>
                    </div>
                    <div class="testo">
                      <?php echo $testiMappe['pacific']['testo'] ?>
                    </div>
                  </div>
                </div>
                <div class="single-box singapore">
                  <div class="testi-box">
                    <div class="titoletto">
                      <?php if($testiMappe['singapore']['immagine_bandiera']) { ?>
                      <img src="<?php echo $testiMappe['singapore']['immagine_bandiera']['url'] ?>" alt=" <?php echo $testiMappe['singapore']['titoletto'] ?> flag">
                        <?php } ?>
                      <?php echo $testiMappe['singapore']['titoletto'] ?>
                    </div>
                    <div class="titolo">
                      <?php if($testiMappe['singapore']['link_collegato']) { ?>
                        <a href="<?php echo $testiMappe['singapore']['link_collegato']['url'] ?>" target="_blank"><?php echo $testiMappe['singapore']['titolo'] ?></a>
                      <?php } else { ?>
                        <?php echo $testiMappe['singapore']['titolo'] ?>
                      <?php }  ?>
                    </div>
                    <div class="testo">
                      <?php echo $testiMappe['singapore']['testo'] ?>
                    </div>
                  </div>
                </div>
                <div class="single-box england">
                  <div class="testi-box">
                    <div class="titoletto">
                      <?php if($testiMappe['england']['immagine_bandiera']) { ?>
                      <img src="<?php echo $testiMappe['england']['immagine_bandiera']['url'] ?>" alt=" <?php echo $testiMappe['england']['titoletto'] ?> flag">
                        <?php } ?>
                      <?php echo $testiMappe['england']['titoletto'] ?>
                    </div>
                    <div class="titolo">
                      <?php if($testiMappe['england']['link_collegato']) { ?>
                        <a href="<?php echo $testiMappe['england']['link_collegato']['url'] ?>" target="_blank"><?php echo $testiMappe['england']['titolo'] ?></a>
                      <?php } else { ?>
                        <?php echo $testiMappe['england']['titolo'] ?>
                      <?php }  ?>
                    </div>
                    <div class="testo">
                      <?php echo $testiMappe['england']['testo'] ?>
                    </div>
                  </div>
                </div>
                <div class="single-box iptest_malesia">
                  <div class="testi-box">
                    <div class="titoletto">
                      <?php if($testiMappe['iptest_malesia']['immagine_bandiera']) { ?>
                      <img src="<?php echo $testiMappe['iptest_malesia']['immagine_bandiera']['url'] ?>" alt=" <?php echo $testiMappe['iptest_malesia']['titoletto'] ?> flag">
                        <?php } ?>
                      <?php echo $testiMappe['iptest_malesia']['titoletto'] ?>
                    </div>
                    <div class="titolo">
                      <?php if($testiMappe['iptest_malesia']['link_collegato']) { ?>
                        <a href="<?php echo $testiMappe['iptest_malesia']['link_collegato']['url'] ?>" target="_blank"><?php echo $testiMappe['iptest_malesia']['titolo'] ?></a>
                      <?php } else { ?>
                        <?php echo $testiMappe['iptest_malesia']['titolo'] ?>
                      <?php }  ?>
                    </div>
                    <div class="testo">
                      <?php echo $testiMappe['iptest_malesia']['testo'] ?>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <script>
        jQuery(document).ready(function($) {
         $('.pin').on('click', function(){
          if ($(this).hasClass('aperto')){
            $('.pin').text('+');
            $('.pin').removeClass('aperto');
            $('.testi-box').removeClass('aperto')
          } else {
            $('.pin').text('+');
            $('.pin').removeClass('aperto');
            $('.testi-box').removeClass('aperto')
            $(this).addClass('aperto');
            $(this).text('-');
            $(this).siblings('.testi-box').addClass('aperto')
          }
         })
        });
      </script>
    </section>

    <section class="sezione section-mission" id="ourMission">
        <?php echo get_field('mission'); ?>
    </section>    
    
    
    <?php 

        $timeline = [
            "en" => [
                1 => ['anno' =>'1999', 'testo' =>'Microtest Foundation'],
                2 => ['anno' =>'1999 - 2002', 'testo' =>'Facilities (mq): 120<br>Employees: 10<br>Customers: 2'],
                3 => ['anno' =>'2004', 'testo' =>'ATE<br>Manufacturing & Design'],
                4 => ['anno' =>'2009', 'testo' =>'M & Mems 32 sites<br>Hatina 4S<br>Ovenless Burn-In'],
                5 => ['anno' =>'2002 - 2009', 'testo' =>'Facilities (mq): 450<br>Employees: 45<br>Customers: 6'],
                6 => ['anno' =>'2009 - 2015', 'testo' =>'Facilities (mq): 1200<br>Employees: 75<br>Customers: 15'],
                7 => ['anno' =>'2017', 'testo' =>'300 Systems Sold'],
                8 => ['anno' =>'2018', 'testo' =>'New Headquarter in Malacca'],
                9 => ['anno' =>'2015 - 2019', 'testo' =>'Facilities (mq): 3000<br>Employees: over 100<br>Customers: over 30'],
                10 => ['anno' =>'2019', 'testo' =>'+100% Revenues in<br>3 Years (2015-2018)<br><b style="font-size: 15px">20<sup>th</sup> anniversary celebration</b>'], 
                11 => ['anno' =>'2021', 'testo' =>'More than 500 ATE sold worldwide'], 
                12 => ['anno' =>'2022', 'testo' =>'<b>Xenon Private Equity</b> acquired a majority stake in Microtest'], 
                13 => ['anno' =>'2023', 'testo' =>'<b>Microtest</b> becomes a joint stock company. Acquisition of <b>Test Inspire</b>, <b>Gedec</b> and <b>RoodMicrotec</b>'], 
                14 => ['anno' =>'2024', 'testo' =>'Acquisition of ipTEST<br>Facilities (mq): +5000<br>Employees: over 400<br><b style="font-size: 15px">25<sup>th</sup> anniversary celebration</b>'], 
            ],
            "it" => [
                1 => ['anno' =>'1999', 'testo' =>'Fondazione di Microtest'],
                2 => ['anno' =>'1999 - 2002', 'testo' =>'Stabilimento (mq): 120<br>Dipendenti: 10<br>Clienti: 2'],
                3 => ['anno' =>'2004', 'testo' =>'ATE<br>Manufacturing & Design'],
                4 => ['anno' =>'2009', 'testo' =>'M & Mems 32 siti<br>Hatina 4S<br>Ovenless Burn-In'],
                5 => ['anno' =>'2002 - 2009', 'testo' =>'Stabilimento (mq): 450<br>Dipendenti: 45<br>Clienti: 6'],
                6 => ['anno' =>'2009 - 2015', 'testo' =>'Stabilimento (mq): 1200<br>Dipendenti: 75<br>Clienti: 15'],
                7 => ['anno' =>'2017', 'testo' =>'300 sistemi venduti'],
                8 => ['anno' =>'2018', 'testo' =>'Nuova sede a Malacca'],
                9 => ['anno' =>'2015 - 2019', 'testo' =>'Stabilimento (mq): 3000<br>Dipendenti: over 100<br>Clienti: over 30'],
                10 => ['anno' =>'2019', 'testo' =>'+100% fatturato in<br>3 anni (2015-2018)<br><b style="font-size: 15px">celebrazioni Ventesimo Anniversario</b>'], 
                11 => ['anno' =>'2021', 'testo' =>'Più di 500 ATE venduti nel mondo'], 
                12 => ['anno' =>'2022', 'testo' =>'<b>Xenon Private Equity</b> acquired a majority stake in Microtest'], 
                13 => ['anno' =>'2023', 'testo' =>'<b>Microtest</b> becomes a joint stock company. Acquisition of <b>Test Inspire</b>, <b>Gedec</b> and <b>RoodMicrotec</b>'],               
                14 => ['anno' =>'2024', 'testo' =>'Acquisizione di ipTEST<br>Stabilimento (mq): +5000<br>Dipendenti: over 400<br><b style="font-size: 15px">celebrazioni 25° Anniversario</b>'], 
            ],
            "zh-hans" => [
                1 => ['anno' =>'1999', 'testo' =>'Microtest 成立'],
                2 => ['anno' =>'1999 - 2002', 'testo' =>'设施 (mq): 120<br>员工: 10<br>客户: 2'],
                3 => ['anno' =>'2004', 'testo' =>'ATE<br>Manufacturing & Design'],
                4 => ['anno' =>'2009', 'testo' =>'M & Mems 32 sites<br>Hatina 4S<br>无烤箱预烧的测试器'],
                5 => ['anno' =>'2002 - 2009', 'testo' =>'设施 (mq): 450<br>员工: 45<br>客户: 6'],
                6 => ['anno' =>'2009 - 2015', 'testo' =>'设施 (mq): 1200<br>员工: 75<br>客户: 15'],
                7 => ['anno' =>'2017', 'testo' =>'出售300台测试设备'],
                8 => ['anno' =>'2018', 'testo' =>'马六甲新总部'],
                9 => ['anno' =>'2015 - 2019', 'testo' =>'设施 (mq): 3000<br>员工: 超过 100<br>客户: 超过  30'],
                10 => ['anno' =>'2019', 'testo' =>'三年(2015-2018)的年收入增加了100%<br><b style="font-size: 15px">20<sup>th</sup> anniversary celebration</b>'], 
                11 => ['anno' =>'2021', 'testo' =>'More than 500 ATE sold worldwide'], 
                12 => ['anno' =>'2022', 'testo' =>'<b>Xenon Private Equity</b> acquired a majority stake in Microtest'], 
                13 => ['anno' =>'2023', 'testo' =>'<b>Microtest</b> becomes a joint stock company. Acquisition of <b>Test Inspire</b>, <b>Gedec</b> and <b>RoodMicrotec</b>'], 
                14 => ['anno' =>'2024', 'testo' =>'Acquisition of ipTEST<br>设施 (mq): +5000<br>员工: 超过 400<br><b style="font-size: 15px">25<sup>th</sup> anniversary celebration</b>'], 
            ]
        ];
        $numeroTraguardi = count($timeline);
    ?>

    <section class="sezione section-timeline" id="history">
        <div class="container">
            <div class="title-h2" style="text-align: center; margin-bottom: 5px;"><?php _e("OUR HISTORY", "microtest"); ?></div>
        </div>
        <div class="container milestones">
            <div class="allMilestones">
                <style>
                    @media screen and (min-width: 992px) {
                        .singleMilestone{
                            width: calc(100% / <?= $numeroTraguardi ?> )
                        }
                    }
                </style>
                <?php 
                    $linguaAttuale = ICL_LANGUAGE_CODE;
                    foreach ($timeline[$linguaAttuale] as $key => $value) {
                        ?>
                        <div class="singleMilestone <?= $linguaAttuale?> anno_<?php echo $value["anno"]?>">
                            <?php 
                                if ( $key % 2){
                                    $verso = "up";
                                } else {
                                    $verso = "down";
                                }
                            ?>
                            <div class="contieniMilestone <?php echo $verso ?>">
                                <div class="anno">
                                    <span><?php echo $value["anno"]?></span>
                                </div>
                                <img src="<?= get_stylesheet_directory_uri()."/img/circle_".$verso.".svg" ?>" alt="">
                                <div class="testoMilestone">
                                    <p><?php echo $value["testo"]?></p>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                ?>
            </div>
            <!-- <div class="finalMilestone">
                 <div class="contieniMilestone">
                    <img src="<?= get_stylesheet_directory_uri()."/img/20years.svg" ?>" alt="">
                </div>
            </div> -->
        </div>

        <script>
        /* rendere scrollable la sezione */
        const elemento_scrollabileX_milestones = document.querySelector('.allMilestones');
        let isDown_Milestones = false;
        let startX_milestones;
        let scrollLeft_milestones;

        elemento_scrollabileX_milestones.addEventListener('mousedown', (e) => {
            isDown_Milestones = true;
            elemento_scrollabileX_milestones.classList.add('active');
            startX_milestones = e.pageX - elemento_scrollabileX_milestones.offsetLeft;
            scrollLeft_milestones = elemento_scrollabileX_milestones.scrollLeft;
        });
        elemento_scrollabileX_milestones.addEventListener('mouseleave', () => {
            isDown_Milestones = false;
            elemento_scrollabileX_milestones.classList.remove('active');
        });
        elemento_scrollabileX_milestones.addEventListener('mouseup', () => {
            isDown_Milestones = false;
            elemento_scrollabileX_milestones.classList.remove('active');
        });
        elemento_scrollabileX_milestones.addEventListener('mousemove', (e) => {
            if(!isDown_Milestones) return;
            e.preventDefault();
            const x = e.pageX - elemento_scrollabileX_milestones.offsetLeft;
            const walk = (x - startX_milestones) * 1.5; //scroll speed
            elemento_scrollabileX_milestones.scrollLeft = scrollLeft_milestones - walk;
            /* console.log(walk); */
        });
      </script>
    </section>

    <?php
   /*  <section class="sezione section-20thanniversary d-none" id="">
        <?php echo get_field('20thanniversary'); ?>
        <div class="container-fluid">
            <div class="row">
                <div class="videoContainer" style="background-image: url(<?php echo get_field('20thanniversary_video_poster'); ?>)">
                    <video id="video20thCelebration" width="100%" height="100%"  poster="img.png">
                        <source src="<?php echo get_field('20thanniversary_video_url'); ?>" type="video/mp4">
                    </video>
                    <div class="playContainer playCelebrations"></div>
                </div>
            </div>
        </div>
    </section>  */   ?>
    
    <section class="sezione section-hq" id="headquarters">
        <?php echo get_field('headquarters'); ?>
    </section>

    <section class="section-portfolio" id="clients">
        <?php echo get_field('portfolio'); ?>
            <div class="container">
                <div class="row d-flex justify-content-center" style="position: relative">
                    <div class="col-md-10 col-lg-8 col-xl-12">
                        <div id="owl-carousel-clients" class="owl-carousel owl-carousel-clients owl-theme">
                            <?php foreach($sliders as $slider) { echo '<img class="client-slider" src="' . $slider .'">'; } ?>
                        </div>
                    </div>
                </div>
            </div>
    </section>

    <section id="certifications" class="sezione section-certifications">
        <div class="container">
            <?php echo get_field('certifications'); ?>
        </div>
    </section>

</main>
<?php get_footer();
