<?php
/**
 * Template Name: Shooting
 * @package Microtest
 */

  $formatter = new IntlDateFormatter(
    'it_IT',
    IntlDateFormatter::FULL,
    IntlDateFormatter::NONE,
    'Europe/Rome',
    IntlDateFormatter::GREGORIAN,
    'd MMMM yyyy'
  );
 /*
  $dateS = "2024-09-04";
  $date = new DateTime($dateS);
  $shooting_date = date('Y-m-d', strtotime($dateS));
  */
  $date2S = "2024-09-19";
  $date2 = new DateTime($date2S);
  $shooting_date2 = date('Y-m-d', strtotime($date2S));

  $h_start = "09:30:00";
  $h_end = "13:10:00";
  $nr_per_slot = 4;
  $durata = 10;

  get_header();
  define('DONOTCACHEPAGE', true);

  function generate_time_slots($start_time, $end_time, $interval_minutes) {
    $start = new DateTime($start_time);
    $end = new DateTime($end_time);
    $interval = new DateInterval('PT' . $interval_minutes . 'M');
    $slots = [];

    while ($start < $end) {
      $slots[$start->format('H:i:s')] = $start->format('H:i');
      $start->add($interval);
    }

    return $slots;
  }

  $time_slots = generate_time_slots($h_start, $h_end, $durata);
?>

<main id="content" class="shooting-dates">
  <div class="container">
    <h1 class="text-center">Gestione appuntamenti per shooting</h1>
   <?php /* <h3 class="text-center"><?= $formatter->format($date); ?> - <?= substr($h_start, 0, 5) ?> / <?= substr($h_end, 0, 5) ?></h3> */ ?>
    <h3 class="text-center"><?= $formatter->format($date2); ?> - <?= substr($h_start, 0, 5) ?> / <?= substr($h_end, 0, 5) ?></h3>
    <p class="text-center"><em>Inserisci la tua email aziendale, seleziona l'orario e prenota lo slot per lo shooting.<br>
    Per facilitare le operazioni fotografiche e creare un flusso continuo, sono previsti slot da  <?= $nr_per_slot ?>  persone, ogni <?= $durata ?> minuti.</em> <br> Se uno slot è completo non sarà possibile prenotarlo. </p>
    <p class="text-center"><em>È possibile modificare la prenotazione cancellando quella precedente.</em></p>
    <p class="text-center" style="font-weight: bold; font-size: 1.2em; color:#27a72c;"><em>Ricorda di segnare l'appuntamento sul calendario, <br>puoi sempre controllare l'orario della prenotazione inserendo nuovamente la tua mail</em></p>

    <!-- <div class="row"  style="display: none">
      <div class="col-md-6">
        <div class="form-group">
          <label for="email">E-mail</label>
          <input type="email" class="form-control" id="email" name="email">
        </div>
      </div>
    </div> -->

    <div class="appuntamenti" style="margin-top: 15px">
<?php /*
      <div class="row">
        <h2 class="is-hidden"><?= $formatter->format($date); ?></h2>
        <?php foreach ($time_slots as $k => $slot): ?>
          <div class="col-4 col-sm-3 col-md-2 col-xl-1 mb-3 is-hidden">
            <button class="btn btn-success" data-slot="<?= $k; ?>" data-data="<?= $dateS; ?>" style="width: 100%; transition: all 0.4s"><?= $slot; ?></button>
          </div>
        <?php endforeach; ?>
      </div>
 */ ?>
      <div class="row">
        <h2 class="is-hidden"><?= $formatter->format($date2); ?></h2>
        <?php foreach ($time_slots as $k => $slot): ?>
<?php if ($slot != '11:10') : ?>
          <div class="col-4 col-sm-3 col-md-2 col-xl-1 mb-3 is-hidden">
            <button class="btn btn-success" data-slot="<?= $k; ?>" data-data="<?= $date2S; ?>" style="width: 100%; transition: all 0.4s"><?= $slot; ?></button>
	  </div>
<?php endif; ?>
        <?php endforeach; ?>
      </div>
    </div>

    <!-- <div class="row invia" style="display: none">
      <div class="col">
        <a class="bottoniNewsDownload" id="invia-email" href="#" style="background-color: #009739; color: white;  padding:8px 20px; font-size: 1em; margin-top: 0">INVIA</a>
      </div>
    </div> -->



    <div class="row" style="display: block; text-align: center; margin-top: 30px; font-size: 1.1em; color: #009739;">
      <div class="col-12">
        Iscrizioni Terminate
      </div>
    </div>
  </div>
</main>

<div class="modal fade modal-conferma">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header" style="background-color: rgba(0, 151, 57,15%); border-bottom: 0">
        <h5 class="modal-title">Conferma appuntamento</h5>
        <button type="button" class="close" data-bs-dismiss="modal" style="    opacity: 1;
    /* margin-right: -36px;
    margin-top: -7px; */
    background-color: transparent;
    border-radius: 20px;
    border: 0;
    width: 32px;
    height: 32px;
    max-width: 32px;
    max-height: 32px;
    color: black;
    display: flex;
    align-items: center;
    justify-content: center;
    position: absolute;
    top: 10px;
    right: 10px;
    -webkit-appearance: none;
    transform: unset; font-size: 2em">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>Vuoi confermare di prenotare l'appuntamento per lo slot delle ore <span id="conferma-slot"></span>?</p>
      </div>
      <div class="modal-footer" style="border-top: 0">
        <button id="annulla-conferma" class="btn btn-danger" data-bs-dismiss="modal">Annulla</button>
        <button type="button" class="btn btn-success" id="conferma-btn">Conferma</button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade modal-esiste">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header" style="background-color: rgb(226, 0, 26,15%); border-bottom: 0">
        <h5 class="modal-title">Appuntamento già esistente</h5>
        <button type="button" class="close" data-bs-dismiss="modal" style="    opacity: 1;
    /* margin-right: -36px;
    margin-top: -7px; */
    background-color: transparent;
    border-radius: 20px;
    border: 0;
    width: 32px;
    height: 32px;
    max-width: 32px;
    max-height: 32px;
    color: black;
    display: flex;
    align-items: center;
    justify-content: center;
    position: absolute;
    top: 10px;
    right: 10px;
    -webkit-appearance: none;
    transform: unset; font-size: 2em">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>L'utente inserito ha già uno slot prenotato alle ore <span id="slot-prenotato" style="font-weight: bold; color: #27a72c;"></span> del <span id="data-prenotata" style="font-weight: bold; color: #27a72c;"></span>. <span class="utente-non-del-4-settembre">Se si vuole eliminarlo o modificarlo, procedere con l'eliminazione.</span></p>
      </div>
      <div class="modal-footer" style="border-top: 0">
        <button id="annulla-esiste" class="btn btn-primary" data-bs-dismiss="modal">Indietro</button>
        <button type="button" class="btn btn-danger" id="elimina-btn">ELIMINAZIONE</button>
      </div>
    </div>
  </div>
</div>

<script>
  jQuery(document).ready(function($) {
    const emailRegex = /^[a-zA-Z0-9._%+-]+@microtest\.net$/;

    $('#email').on('keyup', function() {
      var email = $(this).val();
      if (emailRegex.test(email)) {
        $(this).removeClass('is-invalid').addClass('is-valid');
      } else {
        $(this).removeClass('is-valid').addClass('is-invalid');
      }
    });

    $('#invia-email').on('click', function() {
      var email = $('#email').val();
      $.ajax({
        url: '/wp-admin/admin-ajax.php',
        type: 'GET',
        data: {
          action: 'shooting_check',
          email: email
        },
        success: function(response, status, xhr) {
          if (response.data == "true") {
            $.ajax({
              url: '/wp-admin/admin-ajax.php',
              type: 'POST',
              data: {
                action: 'shooting_date_check',
                email: email,
                nr_per_slot: '<?= $nr_per_slot; ?>',
                date: '<?= $shooting_date; ?>',
                date2: '<?= $shooting_date2; ?>'
              },
              success: function(response, status, xhr) {
                let data = JSON.parse(response.data);
                console.log(data);

                if (data.result === "true") {
                  $('.is-hidden').removeClass('is-hidden');
                  $('.invia').hide();
                  if (data.appuntamenti.length > 0) {
                    $.each(data.appuntamenti, function(k,appuntamento) {
                      $('button[data-slot="' + appuntamento.slot + '"][data-data="<?= $shooting_date; ?>"]').addClass('btn-dark').removeClass('btn-success').attr('disabled', true);
                    });
                  }
                  if (data.appuntamenti2.length > 0) {
                    $.each(data.appuntamenti2, function(k,appuntamento) {
                      $('button[data-slot="' + appuntamento.slot + '"][data-data="<?= $shooting_date2; ?>"]').addClass('btn-dark').removeClass('btn-success').attr('disabled', true);
                    });
                  }
                } else {
                  $('#slot-prenotato').text(data.slot.substring(0,5));
                  $('#data-prenotata').text(data.data);
                  $('.modal-esiste').modal('show');
                  $('#elimina-btn').show();
                  $('.utente-non-del-4-settembre').show();
                  console.log(data.data);
                  if (data.data === '04/09/2024') {
                    $('#elimina-btn').hide();
                    $('.utente-non-del-4-settembre').hide();
                  }
                }
              }
            });
          } else {
            alert('Utente non valido, assicurarsi di aver inserito un indirizzo email valido e riprovare.');
          }
        },
        error: function(xhr, status, error) {
          if (status === "timeout") {
            console.log('La richiesta ha superato il tempo massimo di attesa.');
          } else {
            console.log('Errore nella richiesta: ' + error);
          }
        }
      });
    });

    var slot;
    var data;
    var email;
    $('.appuntamenti').on('click', 'button', function() {
      slot = $(this).data('slot');
      data = $(this).data('data');
      var dateParts = data.split("-");
      dataS = dateParts[2] + "/" + dateParts[1] + "/" + dateParts[0];
      email = $('#email').val();

      let textSlot = $(this).text() + " per il giorno " + dataS;
      $('#conferma-slot').text(textSlot);
      $('.modal-conferma').modal('show');
    });

    $('#conferma-btn').on('click', function() {
      var selectedDate = '<?= $shooting_date; ?>';
      if (data == '<?= $shooting_date2; ?>') {
        selectedDate = '<?= $shooting_date2; ?>';
      }
      console.log(data,selectedDate);

      $('#conferma-btn').attr('disabled', true);
      $.ajax({
        url: '/wp-admin/admin-ajax.php',
        type: 'POST',
        data: {
          action: 'shooting_save',
          email: email,
          slot: slot,
          nr_per_slot: '<?= $nr_per_slot; ?>',
          date: selectedDate
        },
        success: function(response, status, xhr) {
          if (response.data === "true") {
            alert('Appuntamento salvato con successo');
            location.reload();
          } else {
            $('#conferma-btn').attr('disabled', false);
            alert('Errore nel salvataggio dell\'appuntamento');
          }
        },
        error: function(xhr, status, error) {
          $('#conferma-btn').attr('disabled', false);
          console.log('Errore nella richiesta: ' + error);
        }
      });
    });

    $('#elimina-btn').on('click', function() {
      var email = $('#email').val();
      console.log(email);
      $.ajax({
        url: '/wp-admin/admin-ajax.php',
        type: 'POST',
        data: {
          action: 'shooting_delete',
          email: email,
          date: '<?= $shooting_date; ?>'
        },
        success: function(response, status, xhr) {
          console.log(response.data);
          if (response.data === "true") {
            alert('Appuntamento eliminato con successo');
            location.reload();
          } else {
            alert('Errore nell\'eliminazione dell\'appuntamento');
          }
        },
        error: function(xhr, status, error) {
          console.log('Errore nella richiesta: ' + error);
        }
      });
    });
  });
</script>
<?php 
  get_footer();
