<?php
 /**
  * Template Name: About Us
  * @link https://codex.wordpress.org/Template_Hierarchy
  * @package Microtest
  */

get_header();

$id = get_the_ID();

$args = array(
    'post_type' => 'clients'
);

$query = new WP_Query($args);
$sliders = array();
$i=0;
while( $query->have_posts() ) {
    $query->the_post();
    array_push($sliders, get_the_post_thumbnail_url( get_the_ID(), 'post-thumbnail' ) );
    $i++;
}

wp_reset_postdata();

?>


<main id="content" class="main-about-us">
    <div class="about-us-header">
        <div class="thumbnail-hero" style="background-image:url('<?= get_the_post_thumbnail_url() ?>')">
        <div class="container">
            <h1 style=""><?php echo get_field('header_text'); ?></h1>
        </div>
        </div>
        <!-- <div class="the-title">
            
            <h2 style=""><?php the_title(); ?></h2>
        </div> -->
    </div>
    
    <div class="sezione section-about">
      <?php echo get_field('about'); ?>
    </div>

    <section class="sezione section-mission" id="ourMission">
        <?php echo get_field('mission'); ?>
    </section>    
    
    
    <?php 

        $timeline = [
            "en" => [
                1 => ['anno' =>'1999', 'testo' =>'Microtest Foundation'],
                2 => ['anno' =>'1999 - 2002', 'testo' =>'Facilities (mq): 120<br>Employees: 10<br>Customers: 2'],
                3 => ['anno' =>'2004', 'testo' =>'ATE<br>Manufacturing & Design'],
                4 => ['anno' =>'2009', 'testo' =>'M & Mems 32 sites<br>Hatina 4S<br>Ovenless Burn-In'],
                5 => ['anno' =>'2002 - 2009', 'testo' =>'Facilities (mq): 450<br>Employees: 45<br>Customers: 6'],
                6 => ['anno' =>'2009 - 2015', 'testo' =>'Facilities (mq): 1200<br>Employees: 75<br>Customers: 15'],
                7 => ['anno' =>'2017', 'testo' =>'300 Systems Sold'],
                8 => ['anno' =>'2018', 'testo' =>'New Headquarter in Malacca'],
                9 => ['anno' =>'2015 - 2019', 'testo' =>'Facilities (mq): 3000<br>Employees: over 100<br>Customers: over 30'],
                10 => ['anno' =>'2019', 'testo' =>'+100% Revenues in<br>3 Years (2015-2018)<br><b style="font-size: 15px">21<sup>st</sup> anniversary celebration</b>'], 
                11 => ['anno' =>'2021', 'testo' =>'More than 500 ATE sold worldwide'], 
            ],
            "it" => [
                1 => ['anno' =>'1999', 'testo' =>'Fondazione di Microtest'],
                2 => ['anno' =>'1999 - 2002', 'testo' =>'Stabilimento (mq): 120<br>Dipendenti: 10<br>Clienti: 2'],
                3 => ['anno' =>'2004', 'testo' =>'ATE<br>Manufacturing & Design'],
                4 => ['anno' =>'2009', 'testo' =>'M & Mems 32 siti<br>Hatina 4S<br>Ovenless Burn-In'],
                5 => ['anno' =>'2002 - 2009', 'testo' =>'Stabilimento (mq): 450<br>Dipendenti: 45<br>Clienti: 6'],
                6 => ['anno' =>'2009 - 2015', 'testo' =>'Stabilimento (mq): 1200<br>Dipendenti: 75<br>Clienti: 15'],
                7 => ['anno' =>'2017', 'testo' =>'300 sistemi venduti'],
                8 => ['anno' =>'2018', 'testo' =>'Nuova sede a Malacca'],
                9 => ['anno' =>'2015 - 2019', 'testo' =>'Stabilimento (mq): 3000<br>Dipendenti: over 100<br>Clienti: over 30'],
                10 => ['anno' =>'2019', 'testo' =>'+100% fatturato in<br>3 anni (2015-2018)<br><b style="font-size: 15px">celebrazioni Ventunesimo Anniversario</b>'], 
                11 => ['anno' =>'2021', 'testo' =>'Più di 500 ATE venduti nel mondo'], 
            ],
            "zh-hans" => [
                1 => ['anno' =>'1999', 'testo' =>'Microtest 成立'],
                2 => ['anno' =>'1999 - 2002', 'testo' =>'设施 (mq): 120<br>员工: 10<br>客户: 2'],
                3 => ['anno' =>'2004', 'testo' =>'ATE<br>Manufacturing & Design'],
                4 => ['anno' =>'2009', 'testo' =>'M & Mems 32 sites<br>Hatina 4S<br>无烤箱预烧的测试器'],
                5 => ['anno' =>'2002 - 2009', 'testo' =>'设施 (mq): 450<br>员工: 45<br>客户: 6'],
                6 => ['anno' =>'2009 - 2015', 'testo' =>'设施 (mq): 1200<br>员工: 75<br>客户: 15'],
                7 => ['anno' =>'2017', 'testo' =>'出售300台测试设备'],
                8 => ['anno' =>'2018', 'testo' =>'马六甲新总部'],
                9 => ['anno' =>'2015 - 2019', 'testo' =>'设施 (mq): 3000<br>员工: 超过 100<br>客户: 超过  30'],
                10 => ['anno' =>'2019', 'testo' =>'三年(2015-2018)的年收入增加了100%<br><b style="font-size: 15px">21<sup>st</sup> anniversary celebration</b>'], 
                11 => ['anno' =>'2021', 'testo' =>'More than 500 ATE sold worldwide'], 
            ]
        ];
        $numeroTraguardi = count($timeline);
    ?>

    <section class="sezione section-timeline" id="history">
        <div class="container">
            <div class="title-h2" style="text-align: center; margin-bottom: 5px;"><?php _e("OUR HISTORY", "microtest"); ?></div>
        </div>
        <div class="container milestones">
            <div class="allMilestones">
                <style>
                    @media screen and (min-width: 992px) {
                        .singleMilestone{
                            width: calc(100% / <?= $numeroTraguardi ?> )
                        }
                    }
                </style>
                <?php 
                    $linguaAttuale = ICL_LANGUAGE_CODE;
                    foreach ($timeline[$linguaAttuale] as $key => $value) {
                        ?>
                        <div class="singleMilestone <?= $linguaAttuale?>">
                            <?php 
                                if ( $key % 2){
                                    $verso = "up";
                                } else {
                                    $verso = "down";
                                }
                            ?>
                            <div class="contieniMilestone <?php echo $verso ?>">
                                <div class="anno">
                                    <span><?php echo $value["anno"]?></span>
                                </div>
                                <img src="<?= get_stylesheet_directory_uri()."/img/circle_".$verso.".svg" ?>" alt="">
                                <div class="testoMilestone">
                                    <p><?php echo $value["testo"]?></p>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                ?>
            </div>
            <!-- <div class="finalMilestone">
                 <div class="contieniMilestone">
                    <img src="<?= get_stylesheet_directory_uri()."/img/20years.svg" ?>" alt="">
                </div>
            </div> -->
        </div>
    </section>

    <section class="sezione section-20thanniversary" id="">
        <?php echo get_field('20thanniversary'); ?>
        <div class="container-fluid">
            <div class="row">
                <div class="videoContainer" style="background-image: url(<?php echo get_field('20thanniversary_video_poster'); ?>)">
                    <video id="video20thCelebration" width="100%" height="100%"  poster="img.png">
                        <source src="<?php echo get_field('20thanniversary_video_url'); ?>" type="video/mp4">
                    </video>
                    <div class="playContainer playCelebrations"></div>
                </div>
            </div>
        </div>
    </section>    
    
    <section class="sezione section-hq" id="headquarters">
        <?php echo get_field('headquarters'); ?>
    </section>

    <section class="section-portfolio" id="clients">
        <?php echo get_field('portfolio'); ?>
            <div class="container">
                <div class="row d-flex justify-content-center" style="position: relative">
                    <div class="col-md-10 col-lg-8 col-xl-12">
                        <div id="owl-carousel-clients" class="owl-carousel owl-carousel-clients owl-theme">
                            <?php foreach($sliders as $slider) { echo '<img class="client-slider" src="' . $slider .'">'; } ?>
                        </div>
                    </div>
                </div>
            </div>
    </section>

    <section id="certifications" class="sezione section-certifications">
        <div class="container">
            <?php echo get_field('certifications'); ?>
        </div>
    </section>

</main>
<?php get_footer();
