<?php
/**
 * Template for categorie taxonomy
 * 
 * @package Microtest
 */

/* SERVE AL FILTRO */
$args = array(
  'post_type'   => 'products',
  'post_status' => 'publish',
  'meta_key'		=> 'ordine',
	'orderby'			=> 'meta_value',
	'order'				=> 'ASC'
);

$prods = new WP_Query($args);
$categories = array();
$c = array();

foreach($prods->posts as $post) {
  $id = $post->ID;
  $cats = get_the_terms($id, "categorie");

  foreach($cats as $cat) {
    if (!in_array($cat->name, $c)) {
      array_push($c, $cat->name);
      array_push($categories, array(
        "name" => $cat->name,
        "slug" => $cat->slug,
        "id"   => $cat->term_id,)
      );
    }
  }
}
/* FINE */

$term = get_queried_object()->slug;

$p_args = array(
  'posts_per_page' => '-1',
  'post_type' => 'products',
  'tax_query' => array(
    array(
      'taxonomy' => 'categorie',
      'field'    => 'slug',
      'terms'    => $term
    )
  ),
  'meta_key'		=> 'ordine',
	'orderby'			=> 'meta_value',
	'order'				=> 'ASC'
);

$products = new WP_Query($p_args);

get_header();
?>

<div id="content" class="site-content ">
  <div id="primary" class="content-area">
        <main id="main" class="site-main-products container">
          <div id="intro_prodotti">
          <?php
            $translated_page_prodotti_id = icl_object_id(441, 'page', true); // 441 è l'ID della pagina prodotti
            $post = get_post($translated_page_prodotti_id); 
            $content = apply_filters('the_content', $post->post_content); 
            echo $content; 
          ?>
          </div>
            <div class="filtro">
              <a href="<?php _e("/products", "microtest"); ?>" class="products-cat all"><?php _e("All", "microtest"); ?></a>
              <?php foreach($categories as $cate) : ?>
                <a href="<?= get_category_link($cate['id']) ?>" class="products-cat <?= $cate["slug"] ?> <?= $cate["slug"]==$term?'active':'' ?>"><?= $cate["name"] ?></a>
              <?php endforeach ?>
            </div>
          <div class="row">
            <?php 
              if ( $products->have_posts() ) :
			          foreach($products->posts as $prod) :
                  $id = $prod->ID; ?>
                  <div class="product-card">
                    <a href="<?= get_permalink($id) ?>" target="_self">
                      <img class="prod-image" src="<?= get_the_post_thumbnail_url($id, 'full'); ?>">
                        <?php if (get_field("testo_in_griglia_prodotti", $id)){ ?>
                        <p class="testoInGrigliaProdotti"><?= get_field("testo_in_griglia_prodotti", $id) ?></p> 
                      <?php } ?>
                    </a>
                    <div class="more-btn">
                      <a href="<?= get_permalink($id) ?>" target="_self" class="moreButton">
                        <?php _e("MORE", "microtest"); ?>
                      </a>
                    </div>
                    <div class="product-spec">
                      <div class="line-separator"></div>
                      <div class="prod-title">
                        <?= $prod->post_title ?>
                      </div>
                      <div class="applications">
                          <div class="card-img-app">
                          <?php 
                            $apps = get_field('applications', $id);
                            foreach($apps as $app) :
                              $id_app = $app->ID;
                              $icona_verde = get_field('icona_verde', $id_app); ?>
                              <a href="<?= get_permalink($id_app) ?>">
                                <div class="app-img" title="<?= get_the_title($id_app) ?>">
                                  <img src="<?= $icona_verde ?>">
                                </div>
                              </a>
                          <?php endforeach ?>
                          </div>
                      </div>
                    </div>

                  </div>
                  <?php
                endforeach;
              endif; 
				    ?>
          </div>
        </main>
  </div>
</div>

 <?php get_footer();