<?php
 /**
  * Template Name: Audit Template
  * @link https://codex.wordpress.org/Template_Hierarchy
  * @package Microtest
  */

get_header();
/* per evitare la cache di w3cache https://wordpress.org/support/topic/disable-caching-for-a-specific-page/ */
define('DONOTCACHEPAGE', true);
?> 
 
<style>
    #nav-main .loghetto-anniversario,
    #nav-main .offcanvas.offcanvas-end,
    #nav-main .header-actions{
        display: none!important;
        width: 0;
        height:0;
        overflow: hidden;
        opacity: 0;
        cursor-events: none;
    }
    #nav-main .container{
        justify-content: center;
    }
    #page{
        background-color: rgb(220, 240, 227);
    }
    #breadcrumbs{
        opacity: 0;
        cursor-events: none;
    }
    #main{
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
        flex-direction: column;
    }
    #main .container{
        display: flex;
        align-items: center;
        justify-content: center;
        flex-direction: column;
    }
    #main h1{
        padding: 35px 0 30px;
        margin: 0;
    }

    #main iframe{
        width: 100%;
        max-width: 660px;
    }
    #main .intestazione{
        width: 95%;
        max-width: 590px;
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
        border-radius: 15px;
        min-height: 220px;
        margin-top: 25px;
    }
    #main .intestazione img{
        /* width: 60%;
        height: auto;
        max-width: 350px; */
        border-radius: 15px;
        border-bottom-left-radius: 0;
    }
</style>

<main id="main" class="audit">
    <div class="container">
        <div class="intestazione">
            <img class="logoBianco" src="<?= get_field('immagine_audit') ?>" alt="banner audit">
        </div>
        <div class="contenuto" style="width: 100%;">
            <?php 
            /* mi salvo la data odierna e di fine evento */
            $fine= get_field('fine_raccolta_dati');
            date_default_timezone_set('Europe/Rome');
            $adesso = new DateTime('now');
            $adesso=$adesso->format('YmdHi');
            /* echo $adesso.'<br>';
            echo $fine.'<br>'; */
            /* trasformo la data in secondi */
            /* $adesso = strtotime($adesso);
            $fine = strtotime($fine); */

            /* echo $adesso.'<br>';
            echo $fine.'<br>'; */
            
            /* confronto le date */
            if ($adesso < $fine) {
                ?>
                    <div class="iframe">
                        <?php 
                            the_content();
                        ?>
                    </div>
                    <script type="text/javascript">
                        jQuery(document).ready(function($){
                            /* console.log('evento in corso'); */
                        });
                    </script>
                <?php
            } else {
                ?>
                <div class="contieni-testo-conclusivo" style="min-height: 600px; margin-top: 20px; ">
                    <p style="font-weight: 500; color: rgb(0, 151, 57); font-size: 20px">Raccolta dati Conclusa</p>
                </div>
                <script type="text/javascript">
                    jQuery(document).ready(function($){
                        /* console.log('tempo scaduto'); */
                    });
                </script>
                <?php
            }
            /* if (){ */
                ?>
        </div>
        
    </div>
</main>
<?php get_footer();
