<?php
require_once(get_stylesheet_directory().'/cpt_products.php');
require_once(get_stylesheet_directory().'/cpt_applications.php');
require_once(get_stylesheet_directory().'/cpt_clients.php');
require_once(get_stylesheet_directory().'/cpt_positions.php');
require_once(get_stylesheet_directory().'/cpt_events.php');
require_once(get_stylesheet_directory(). '/breadcrumbs.php');

// style and scripts
add_action('wp_enqueue_scripts', 'bootscore_child_enqueue_styles');
function bootscore_child_enqueue_styles() {
  $versione = '1.100' /* pubblicazione della pagina di 'shooting' per la prenotazione dello slot */;
  // style.css
  wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css', [], $versione );
  wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/css/custom.css', [], $versione );
  wp_enqueue_style( 'another-child-style', get_stylesheet_directory_uri() . '/css/custom-another.css', [], $versione );
  wp_enqueue_style( 'responsive-style', get_stylesheet_directory_uri() . '/css/responsive.css', [], $versione );
  wp_enqueue_style( 'custom-2024-style', get_stylesheet_directory_uri() . '/css/custom-2024.css', [], $versione );


  wp_enqueue_style( 'owlcarousel-min-style', get_stylesheet_directory_uri() . '/lib/owlcarousel/assets/owl.carousel.min.css' );
  wp_enqueue_style( 'owlcarousel-default-style', get_stylesheet_directory_uri() . '/lib/owlcarousel/assets/owl.theme.green.min.css' );
  //   wp_enqueue_style('mautic', get_stylesheet_directory_uri() . '/css/mautic.css');

  // Compiled Bootstrap
  $modified_bootscoreChildCss = date('YmdHi', filemtime(get_stylesheet_directory() . '/css/lib/bootstrap.min.css'));
  wp_enqueue_style('bootstrap', get_stylesheet_directory_uri() . '/css/lib/bootstrap.min.css', array('parent-style'), $modified_bootscoreChildCss);
  
  // custom.js
  wp_enqueue_script('custom-js', get_stylesheet_directory_uri() . '/js/custom.js', false, $versione, true);
  wp_enqueue_script('owlcarousel-js', get_stylesheet_directory_uri() . '/lib/owlcarousel/owl.carousel.min.js', false, '', true);


   /* libreria swiper per carousel */
  wp_enqueue_style('swipe-style-cdn', 'https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.css');
  wp_enqueue_script('swipe-js-cdn', 'https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.js');
}

// Aggiorno il CSS nell’area amministratore
function admin_style() {
  wp_enqueue_style('admin-style', get_stylesheet_directory_uri() . '/css/custom-admin.css');
}

// Esegue la funzione admin_style() all’azione admin_enqueue_scripts di WP
add_action('admin_enqueue_scripts', 'admin_style');

// show featured images in dashboard
add_image_size( 'microtest-admin-post-featured-image', 60, 60, false );

// Add the posts and pages columns filter. They both use the same function.
add_filter('manage_products_posts_columns', 'microtest_add_post_admin_thumbnail_column', 2);
//add_filter('manage_pages_columns', 'microtest_add_post_admin_thumbnail_column', 2);

// Add the column
function microtest_add_post_admin_thumbnail_column($microtest_columns){
    //$microtest_columns['microtest_thumb'] = __('Image');
    $microtest_columns = array('microtest_thumb' => __('Image')) + $microtest_columns;
    return $microtest_columns;
}

// Manage Post and Page Admin Panel Columns
add_action('manage_posts_custom_column', 'microtest_show_post_thumbnail_column', 5, 2);
add_action('manage_pages_custom_column', 'microtest_show_post_thumbnail_column', 5, 2);

// Get featured-thumbnail size post thumbnail and display it
function microtest_show_post_thumbnail_column($microtest_columns, $microtest_id){
    switch($microtest_columns){
        case 'microtest_thumb':
        if( function_exists('the_post_thumbnail') ) {
            echo the_post_thumbnail( 'microtest-admin-post-featured-image' );
        }
        else
            echo 'hmm… your theme doesn\'t support featured image…';
        break;
    }
}

/**
 * Aggiunge il combi select al WPCF7 Careers
 * @link: https://pineco.de/dynamic-select-list-in-contact-form-7/
 */
function adp_dynamic_select_field_values ( $scanned_tag, $replace ) {  

	if ( $scanned_tag['name'] != 'position' && $scanned_tag['name'] != 'subject' ){
    return $scanned_tag;
  }


	if ( $scanned_tag['name'] == 'position' ) {
    $rows = get_posts(
      array ( 
        'post_type' => 'position',  
        'numberposts' => -1,  
        'orderby' => 'title',  
        'order' => 'ASC' ,
           'suppress_filters' => false,
      )
    );  
  
    if ( ! $rows ) return $scanned_tag;
  
    foreach ( $rows as $row ) {  
        $scanned_tag['raw_values'][] = $row->post_title . '|' . $row->post_title;
    }
  
    $pipes = new WPCF7_Pipes($scanned_tag['raw_values']);
  
    $scanned_tag['values'] = $pipes->collect_befores();
    $scanned_tag['labels'] = $pipes->collect_afters();
    $scanned_tag['pipes'] = $pipes;
  
    return $scanned_tag;  
  }

	if ( $scanned_tag['name'] == 'subject' ) {
    $rows = get_posts(
      array ( 
        'post_type' => 'products',  
        'numberposts' => -1,  
        'orderby' => 'title',  
        'order' => 'ASC' ,
           'suppress_filters' => false,
      )
    );  
  
    if ( ! $rows ) return $scanned_tag;
  
    foreach ( $rows as $row ) {  
      $scanned_tag['raw_values'][] = get_field('stringa_pipedrive',$row->ID) . '|' . $row->post_title;
    }
    
    /* $general_inquiry = __('General Inquiry', 'microtest'); */
    $other = __('Other', 'microtest');
    $thServices = __('Test House Services', 'microtest');
    $adServices = __('Asic Design Services', 'microtest');
    $scServices = __('Supply Chain Services', 'microtest');
    /* $scanned_tag['raw_values'][] =  $general_inquiry . '|' .  $general_inquiry; */
    $scanned_tag['raw_values'][] = $thServices . '|' . $thServices;
    $scanned_tag['raw_values'][] = $adServices . '|' . $adServices;
    $scanned_tag['raw_values'][] = $scServices . '|' . $scServices;
    $scanned_tag['raw_values'][] = $other . '|' . $other; 
  
    $pipes = new WPCF7_Pipes($scanned_tag['raw_values']);
  
    $scanned_tag['values'] = $pipes->collect_befores();
    $scanned_tag['labels'] = $pipes->collect_afters();
    $scanned_tag['pipes'] = $pipes;
  
    return $scanned_tag;  
  }

}  

add_filter( 'wpcf7_form_tag', 'adp_dynamic_select_field_values', 10, 2); 

function wpdocs_custom_excerpt_length( $length ) {
	return 20;
}
add_filter( 'excerpt_length', 'wpdocs_custom_excerpt_length', 999 );


/* questo filtro aggiungge i file richiesti dagli utenti tramite il form alla mail che riceveranno */
/* https://stackoverflow.com/questions/48189010/dynamically-attaching-file-to-contact-form-7-e-mail */
add_filter('wpcf7_mail_components', 'custom_wpcf7_mail_components');
function custom_wpcf7_mail_components($components) {
    //Get current form
    $wpcf7 = WPCF7_ContactForm::get_current();
    $attachment_file_path = '';
    
    /* id dei form che dovranno allegare i file nella mail degli utenti, bisognerà duplicarli per l'inglese  e cinese*/
    $cf7IdArray = [2467,2469,2468,774,2467,2464];
    if (in_array($wpcf7->id,$cf7IdArray)) {
        
        // get current SUBMISSION instance
        $submission = WPCF7_Submission::get_instance();

        if ($submission) {
            // get submission data
            $data = $submission->get_posted_data();

            if (!str_contains($components['subject'], "Admin")) {
                //$upload_dir = get_stylesheet_directory_uri();
                $upload_dir = WP_CONTENT_DIR."/themes/microtest-official";
                
                $file_name = $data['datasheet_file'];//E' nel custom filed
                $file_dir = 'pdf';
                $attachment_file_path = $upload_dir .'/'.$file_dir.'/'.$file_name;
                //append new file to mail attachments
                $components['attachments'][] = $attachment_file_path;
            }
        }
    }
    
    return $components;
}

add_filter('wpcf7_autop_or_not', '__return_false');

add_action( 'wp_ajax_acconsentito', 'acconsentito_wp_ajax_function' );
add_action( 'wp_ajax_nopriv_acconsentito', 'acconsentito_wp_ajax_function' );

function acconsentito_wp_ajax_function() {
    $page_id = $_POST['id'];
    $page = get_post($page_id);

    // $duration = time()+60*60;//Un'ora
    // setcookie("lettura_acconsentita","1",$duration,"/","www.microtest.net");

    // Cosa faccio nel DB???

    echo $page->post_content;
    exit;
}

/**
 * Hook che consente l'iscrizione a MailUp di un utente e su Pipedrive.
 * @author Pier Luigi Papeschi (Mailup) & Giacomo Suffredini (pipedrive)
 * @since 28.5.24
 */
define('TOKEN_API', '1e6fb679ce80193ab97e039c320491de11d15c81');
define('COMPANY_DOMAIN', 'microtest');
define('OWNER_ID', 21109501); //user id utente Simona su Pipedrive
add_action('wpcf7_mail_sent', function ($cf7) {
    /* file_put_contents('/homez.1032/xecpecj/microtest.net/pipedrive.log', "\r\n".date("Y-m-d H:i:s")."\r\nPOST:".print_r($_POST,true), FILE_APPEND); */


    $formInviato = 'Contact us form';
    switch ($cf7->id) {
        case 2467: // EN - Datasheet
        case 2468: // ZN - Datasheet
        case 2469: // IT - Datasheet
            $nome = $_POST['your-name'];
            $cognome = $_POST['your-surname'];
            $email = $_POST['your-email'];
            $formInviato = 'Datasheet form';
            break;
        default:
            $nome = $_POST['first-name'];
            $cognome = $_POST['last-name'];
            $email = $_POST['email'];
    }

    switch ($cf7->id) {
        case 774: // EN - More Info
        case 2465: // ZN - More Info
        case 2466: // IT - More Info
          $company = $_POST['company'];
          $formInviato = 'More Info form';
          break;
        default:
          $company = $_POST['company-name'];
    }


    /* salvataggio contatto su mailup */
    if ($_POST['acceptance-newsletter'] == "Yes") {
        $mailup_console_url = 'a6h3h3.mailupclient.com';
        $pars    = 'list=1'; 
        $pars   .= '&group=9,20';
        $pars   .= '&email='.$email;
        $pars   .= '&confirm=false'; /* il valore "off" disabilita il double opt-in per l'iscrizione alla newsletter */
        $pars   .= '&csvFldNames=campo1;campo2';
        $pars   .= '&csvFldValues='.$nome.';'.$cognome;
        $mailup_subscription_url = "https://{$mailup_console_url}/frontend/xmlsubscribe.aspx";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $mailup_subscription_url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $pars);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        curl_close($ch);

        // file_put_contents('/homez.1032/xecpecj/microtest.net/mailup.log', "\r\n".date("Y-m-d H:i:s")."\r\nURL: ".$mailup_subscription_url."\r\nParametri: ".$pars."\r\nRisultato CURL: ".$result, FILE_APPEND);
    }

    /* SE IL FORM INVIATO NON è UN CAREER salva cose su pipedrive */
    if (($cf7->id != 881) && ($cf7->id != 2314) && ($cf7->id != 2313)) {
      /* salvataggio contatto su pipedrive */
      $url_search = 'https://'.COMPANY_DOMAIN.'.pipedrive.com/api/v1/organizations/search?api_token='.TOKEN_API.'&term='.$company.'&fields=name';

      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $url_search);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      $output = curl_exec($ch);

      $result = json_decode($output, true);
      
      curl_close($ch);


      if (empty($result['data']['items'])) {
          // Organizzazione non ancora presente, quindi creo organizzazione e persona
          $data = array(
              'name' => $company,
              'owner_id' => OWNER_ID,
              'visible_to' => 3,
          );


          if($_POST['country']){
            $data['address'] = $_POST['country'];
          }  

          $crea_org = 'https://'.COMPANY_DOMAIN.'.pipedrive.com/api/v1/organizations?api_token='.TOKEN_API;
          $ch = curl_init();
          curl_setopt($ch, CURLOPT_URL, $crea_org);
          curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
          curl_setopt($ch, CURLOPT_POST, true);
          curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
          
          $output = curl_exec($ch);

          curl_close($ch);

          $result = json_decode($output, true);

          if (empty($result['data']['id'])) {
              // Errore, qualcosa non ha fatto salvare su PD
              $r['esito'] = "0";
          } else {
              $org = $result['data']['id'];
          }
          /* my_custom_log($result['data']);
          my_custom_log('di sopra'); */
      } else {
          // Organizzazione presente, quindi creo la persona e la associo all'organizzazione
          $org = $result['data']['items'][0]['item']['id'];

          // if($_POST['country'] && !($result['data']['items'][0]['item']['address']) ){
          //   /* $newData['address'] = $_POST['country']; */
          //   $newData['address'] = $_POST['country'];

          //   // Pipedrive API URL for updating a person
          //   $updateUrl = "https://".COMPANY_DOMAIN.".pipedrive.com/v1/organizations/".$org."?api_token=".TOKEN_API;
          //   // Initialize cURL session for update
          //   $ch = curl_init();
          //   curl_setopt($ch, CURLOPT_URL, $updateUrl);
          //   curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
          //   curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
          //   curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($newData));
          //   curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/x-www-form-urlencoded']);
            
          //   // Execute cURL session for update
          //   $updateResponse = curl_exec($ch);
          //   curl_close($ch);

          // }
        }
        




      // Salvo il cliente
      $url_check_user = 'https://'.COMPANY_DOMAIN.'.pipedrive.com/v1/persons/search?api_token='.TOKEN_API.'&term='.$email.'&fields=email';

      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $url_check_user);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      $output = curl_exec($ch);

      $result = json_decode($output, true);
      
      curl_close($ch);


      if (empty($result['data']['items'])) {
          // persona non ancora presente, quindi creo la persona
          $data = array(
              'name' => $nome.' '.$cognome,
              'owner_id' => OWNER_ID,
              'org_id' => $org,
              'email' => $email,
              /* 'phone' => $_POST['phone'], */
              'visible_to' => 3,

              /* altri campi https://developers.pipedrive.com/docs/api/v1/Persons */
          );
          

          if($_POST['country']){
            $data['4216139bcb91b0f983f0e811e76d24b0ed4302ec'] = $_POST['country']; /* campo location */
          }

          $crea_pers = 'https://'.COMPANY_DOMAIN.'.pipedrive.com/api/v1/persons?api_token='.TOKEN_API;
          $ch = curl_init();
          curl_setopt($ch, CURLOPT_URL, $crea_pers);
          curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
          curl_setopt($ch, CURLOPT_POST, true);
          curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
          
          $output = curl_exec($ch);
          curl_close($ch);

          $result = json_decode($output, true);

          if (empty($result['data']['id'])) {
              // Non ha salvato
              $r['esito'] = 0;
          } else {
              $pers_id = $result['data']['id'];
              $r['esito'] = $result['data']['id'];
          }
      } else {
          // Persona presente, quindi prendo l'id e poi aggiorno i dati con quelli nuovi ricevuto dal form
          $pers_id = $result['data']['items'][0]['item']['id'];

          $newData = [
              'name' => $nome.' '.$cognome,
              'owner_id' => OWNER_ID,
              'org_id' => $org,
              'email' => $email,
              /* 'phone' => $_POST['phone'], */
              'visible_to' => 3,
          ];
          if($_POST['country']){
            $newData['4216139bcb91b0f983f0e811e76d24b0ed4302ec'] = $_POST['country']; /* campo location */
          }

          $items = $result['data']['items'];
          
          // Pipedrive API URL for updating a person
          $updateUrl = "https://api.pipedrive.com/v1/persons/".$pers_id."?api_token=".TOKEN_API;
          // Initialize cURL session for update
          $ch = curl_init();
          curl_setopt($ch, CURLOPT_URL, $updateUrl);
          curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
          curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
          curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($newData));
          curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/x-www-form-urlencoded']);
          
          // Execute cURL session for update
          $updateResponse = curl_exec($ch);
          curl_close($ch);

          // Decode the update response
          $updateResult = json_decode($updateResponse, true);

          /* if ($updateResult['success']) {
            my_custom_log('User updated successfully.');
          } else {
            my_custom_log('Failed to update user: ' . $updateResult['error']);
          } */


      }


      if($pers_id){ // ID della persona a cui associare il lead
        // Creo il lead
        $title = $nome.' '.$cognome.' | '. $company;  // Titolo del lead
        /* my_custom_log($title);
        my_custom_log($pers_id); */

        $url = "https://".COMPANY_DOMAIN.".pipedrive.com/api/v1/leads?api_token=".TOKEN_API;


        $data = [
            'title' => $title,
            'person_id' => $pers_id,
            'owner_id' => OWNER_ID,
            'organization_id' => $org,
            'channel' => 89 /* aggiorno il campo 'Source channel' e gli assegno l'id che corrisponde a Website Request, API endpoint per vedere l'id https://microtest.pipedrive.com/api/v1/dealFields/12501?api_token=1e6fb679ce80193ab97e039c320491de11d15c81 dove 12501 l'id del campo 'Source channel' */
            
        ];

        /* se so quale prodotto associare al lead, lo associo al campo corretto */
        if($_POST['product_name'] || $_POST['datasheet_product'] || $_POST['subject']){
          if($_POST['product_name']){
            $prodottoCollegato = $_POST['product_name'];
          }
          if($_POST['datasheet_product']){
            $prodottoCollegato = $_POST['datasheet_product'];
          }
          if($_POST['subject']){
            $prodottoCollegato = $_POST['subject'];
          }
          $fieldKey = 'd7eb559c33b4c9af3719a198344f68d54d26c9ba';  // Il key del campo multipleOption specifico

          // URL per ottenere i campi personalizzati dei Deals
          $url_custom_fields = "https://".COMPANY_DOMAIN.".pipedrive.com/api/v1/dealFields?api_token=".TOKEN_API;

          $ch_cfield = curl_init($url_custom_fields);

          curl_setopt($ch_cfield, CURLOPT_RETURNTRANSFER, true);
          curl_setopt($ch_cfield, CURLOPT_HTTPHEADER, [
              'Content-Type: application/json'
          ]);

          $response = curl_exec($ch_cfield);

          $arrayProdottiCollegati = [];

          if (curl_errno($ch_cfield)) {
              echo 'Error:' . curl_error($ch_cfield);
          } else {
              $httpcode = curl_getinfo($ch_cfield, CURLINFO_HTTP_CODE);
              /* my_custom_log('codice httpcode '. $httpcode); */
              if ($httpcode == 200) {
                  $responseData = json_decode($response, true);
                  if ($responseData['success']) {
                      $fields = $responseData['data'];
                      /* my_custom_log('Fields:');
                      my_custom_log($fields); */
                      /* my_custom_log($fields); */
                      $customFieldTrovato;
                      foreach ($fields as $field) {
                          if ($field['key'] == $fieldKey && $field['field_type'] == 'set') {
                              /* my_custom_log(  'Field ID: ' . $field['id'] . "\n");
                              my_custom_log('Field Name: ' . $field['name'] . "\n");
                              my_custom_log( 'Options:' . "\n"); */
                              $customFieldTrovato = $field;
                              break;
                              /* my_custom_log($arrayProdottiCollegati);  */
                          }
                      }
                      foreach ($customFieldTrovato['options'] as $option) {
                        if($prodottoCollegato === $option['label']){
                          /* $arrayProdottiCollegati[$option['id']] = $option['label']; */
                          $arrayProdottiCollegati[] = $option['id'];
                        }
                        /* my_custom_log(' - ' . $option['label'] . ' (ID: ' . $option['id'] . ")\n"); */
                      }
                        /* my_custom_log($arrayProdottiCollegati); */

                  } else {
                      /* echo 'Failed to retrieve fields: ' . $responseData['error']; */
                      /* my_custom_log('Non funziona per respondeDataVuoto'); */
                  }
              } else {
                  /* echo "HTTP Error Code: $httpcode\nResponse: $response"; */
              }
          }

          curl_close($ch_cfield);


          /* $data[$fieldKey] = $_POST['product_name']; */
          $data[$fieldKey] = $arrayProdottiCollegati;
          /* $data['d7eb559c33b4c9af3719a198344f68d54d26c9ba'] = 6; */
          /* my_custom_log('Nome Prodotto '.$_POST['product_name']); */
        }

        /* nel campo personalizzato pipedrive di 'messaggio inserito' salvo l'evenutuale messaggio inserito nel form */
        if($_POST['your-message']){
          $data['3f997a4aae40779a86a8c98bceac6c8deca5f79d'] = $_POST['your-message'];
        }
        

        /* nel campo personalizzato pipedrive di 'Form Compilato' salvo la tipologia di form che ha portato al salvataggio */
        $data['fdc04753759aa4a2c608bb19f944d9667329d824'] = $formInviato;
        


        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json'
        ]);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

        $response = curl_exec($ch);

        /*  my_custom_log($response);
        my_custom_log('response lead'); */

        curl_close($ch);

        /* my_custom_log($response); */
      }

    }
});




/**
 * Controlla la validità dell'email e niente più.
 */
add_action( 'wp_ajax_shooting_check', 'shooting_check_wp_ajax_function' );
add_action( 'wp_ajax_nopriv_shooting_check', 'shooting_check_wp_ajax_function' );
function shooting_check_wp_ajax_function() 
{
  $email = $_GET['email'];
  
  global $wpdb;
  $query = $wpdb->prepare("SELECT * FROM {$wpdb->prefix}microtest_internal WHERE email = %s", $email);
  $results = $wpdb->get_results($query);

  if (count($results) > 0) {
    wp_send_json_success('true');
  } else {
    wp_send_json_error('false');
  }
}

add_action( 'wp_ajax_shooting_date_check', 'shooting_date_check_wp_ajax_function' );
add_action( 'wp_ajax_nopriv_shooting_date_check', 'shooting_date_check_wp_ajax_function' );
function shooting_date_check_wp_ajax_function() 
{
  $email = $_POST['email'];
  $nr_per_slot = $_POST['nr_per_slot'];
  $shooting_date = $_POST['date'];
  $shooting_date2 = $_POST['date2'];
  
  global $wpdb;
  $query = $wpdb->prepare("SELECT slot, DATE_FORMAT(shooting_date,'%%d/%%m/%%Y') shoot_date FROM {$wpdb->prefix}shooting WHERE email = %s", $email);
  $results = $wpdb->get_results($query);

  if (count($results) > 0) {
    $result = ['result' => 'false', 'message' => 'Utente ha già prenotato il proprio appuntamento', 'slot' => $results[0]->slot, 'data' => $results[0]->shoot_date];
    wp_send_json_success(json_encode($result));
  } else {
    $sql = $wpdb->prepare("SELECT slot, COUNT(*) FROM {$wpdb->prefix}shooting WHERE shooting_date = %s GROUP BY slot HAVING COUNT(*) = %d", $shooting_date, $nr_per_slot);
    $slots = $wpdb->get_results($sql);

    $sql2 = $wpdb->prepare("SELECT slot, COUNT(*) FROM {$wpdb->prefix}shooting WHERE shooting_date = %s GROUP BY slot HAVING COUNT(*) = %d", $shooting_date2, $nr_per_slot);
    $slots2 = $wpdb->get_results($sql2);

    $result = ['result' => 'true', 'message' => 'Disponibile per l\'appuntamento', 'appuntamenti' => $slots, 'appuntamenti2' => $slots2];

    wp_send_json_success(json_encode($result));
  }
}

add_action( 'wp_ajax_shooting_save', 'shooting_save_wp_ajax_function' );
add_action( 'wp_ajax_nopriv_shooting_save', 'shooting_save_wp_ajax_function' );
function shooting_save_wp_ajax_function() 
{
  $email = $_POST['email'];
  $slot = $_POST['slot'];
  $nr_per_slot = $_POST['nr_per_slot'];
  $shooting_date = $_POST['date'];

  global $wpdb;
  $checkSql = "SELECT slot, COUNT(*) FROM {$wpdb->prefix}shooting WHERE slot = STR_TO_DATE('$slot', '%H:%i:%s') AND shooting_date = '{$shooting_date}' GROUP BY slot HAVING COUNT(*) = $nr_per_slot";
  $isFree = $wpdb->get_results($checkSql);

  if (count($isFree) > 0) {
    wp_send_json_success('false');
    exit;
  }

  $query = $wpdb->prepare("INSERT INTO {$wpdb->prefix}shooting (email, slot, shooting_date) VALUES (%s, %s, %s)", $email, $slot, $shooting_date);
  $results = $wpdb->query($query);

  if ($results) {
    wp_send_json_success('true');
  } else {
    wp_send_json_success('false');
  }
}

add_action( 'wp_ajax_shooting_delete', 'shooting_delete_wp_ajax_function' );
add_action( 'wp_ajax_nopriv_shooting_delete', 'shooting_delete_wp_ajax_function' );
function shooting_delete_wp_ajax_function() 
{
  $email = $_POST['email'];
  // $shooting_date = $_POST['date'];

  global $wpdb;
  $delete = $wpdb->prepare("DELETE FROM {$wpdb->prefix}shooting WHERE email = %s", $email);
  $result = $wpdb->query($delete);

  if ($result) {
    wp_send_json_success('true');
  } else {
    wp_send_json_success('false');
  }
}