<?php
add_action( 'init', 'create_ClientsPost' );

function create_ClientsPost()
{
  $labels = array(
    'name'               => __( 'Clients' ),
    'singular_name'      => __( 'Client' ),
    'menu_name'          => __( 'Clients' ),
    'name_admin_bar'     => __( 'Clients' ),
    'add_new'            => __( 'Aggiungi nuovo' ),
    'add_new_item'       => __( 'Aggiungi nuovo cliente' ),
    'new_item'           => __( 'Nuovo cliente' ),
    'edit_item'          => __( 'Modifica Cliente' ),
    'view_item'          => __( 'Visualizza Cliente' ),
    'all_items'          => __( 'Tutti i Clienti' ),
    'search_items'       => __( 'Cerca Cliente' ),
    'parent_item_colon'  => __( 'Cliente Genitore' ),
    'not_found'          => __( 'Cliente non trovato' ),
    'not_found_in_trash' => __( 'Nessuna cliente nel cestino' )
  );

  $args = array(
		'labels'              => $labels,
		'public'              => true,
    'publicly_queryable'  => true,
    'exclude_from_search' => false,
    'query_var'           => true,
    'has_archive'         => true,
    'can_export'          => true,
    'menu_position'       => 8,
    'menu_icon'           => 'dashicons-buddicons-buddypress-logo',
    'show_ui'             => true,
    'supports'            => array('title', 'editor', 'author', 'page-attributes', 'thumbnail', 'revisions', 'custom-fields')
	);

  register_post_type('clients', $args);
}